/*
 * Decompiled with CFR 0.152.
 */
package me.fallenbreath.tweakermore.config.options;

import fi.dy.masa.malilib.config.IConfigBase;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.util.StringUtils;
import java.util.function.Function;
import me.fallenbreath.tweakermore.config.TweakerMoreConfigs;
import me.fallenbreath.tweakermore.config.TweakerMoreOption;
import org.jetbrains.annotations.Nullable;

public interface TweakerMoreIConfigBase
extends IConfigBase {
    public static final String TWEAKERMORE_NAMESPACE_PREFIX = "tweakermore.config.";
    public static final String COMMENT_SUFFIX = ".comment";
    public static final String PRETTY_NAME_SUFFIX = ".pretty_name";

    public void onValueChanged(boolean var1);

    default public void setCommentModifier(@Nullable Function<String, String> commentModifier) {
        this.getTweakerMoreOption().setCommentModifier(commentModifier);
    }

    default public String getCommentNoFooter() {
        TweakerMoreOption option = this.getTweakerMoreOption();
        option.setAppendFooterFlag(false);
        try {
            String string = this.getComment();
            return string;
        }
        finally {
            option.setAppendFooterFlag(true);
        }
    }

    default public void updateStatisticOnUse() {
        this.getTweakerMoreOption().getStatistic().onConfigUsed();
    }

    default public String getConfigGuiDisplayName() {
        return StringUtils.translate((String)(TWEAKERMORE_NAMESPACE_PREFIX + this.getName()), (Object[])new Object[0]);
    }

    default public TweakerMoreOption getTweakerMoreOption() {
        return TweakerMoreConfigs.getOptionFromConfig(this).orElseThrow(() -> new RuntimeException("TweakerMoreIConfigBase " + String.valueOf(this) + " not in TweakerMoreConfigs"));
    }

    default public Function<String, String> getGuiDisplayLineModifier() {
        TweakerMoreOption tweakerMoreOption = this.getTweakerMoreOption();
        if (!tweakerMoreOption.isEnabled()) {
            return line -> GuiBase.TXT_DARK_RED + line + GuiBase.TXT_RST;
        }
        if (tweakerMoreOption.isDebug()) {
            return line -> GuiBase.TXT_BLUE + line + GuiBase.TXT_RST;
        }
        if (tweakerMoreOption.isDevOnly()) {
            return line -> GuiBase.TXT_LIGHT_PURPLE + line + GuiBase.TXT_RST;
        }
        return line -> line;
    }
}

