/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.util.data.tag.converter;

import fi.dy.masa.malilib.MaLiLib;
import fi.dy.masa.malilib.util.data.tag.BaseData;
import fi.dy.masa.malilib.util.data.tag.ByteArrayData;
import fi.dy.masa.malilib.util.data.tag.ByteData;
import fi.dy.masa.malilib.util.data.tag.CompoundData;
import fi.dy.masa.malilib.util.data.tag.DoubleData;
import fi.dy.masa.malilib.util.data.tag.FloatData;
import fi.dy.masa.malilib.util.data.tag.IntArrayData;
import fi.dy.masa.malilib.util.data.tag.IntData;
import fi.dy.masa.malilib.util.data.tag.ListData;
import fi.dy.masa.malilib.util.data.tag.LongArrayData;
import fi.dy.masa.malilib.util.data.tag.LongData;
import fi.dy.masa.malilib.util.data.tag.ShortData;
import fi.dy.masa.malilib.util.data.tag.StringData;
import javax.annotation.Nullable;
import net.minecraft.class_2479;
import net.minecraft.class_2481;
import net.minecraft.class_2487;
import net.minecraft.class_2489;
import net.minecraft.class_2494;
import net.minecraft.class_2495;
import net.minecraft.class_2497;
import net.minecraft.class_2499;
import net.minecraft.class_2501;
import net.minecraft.class_2503;
import net.minecraft.class_2516;
import net.minecraft.class_2519;
import net.minecraft.class_2520;

public class DataConverterNbt {
    @Nullable
    public static BaseData fromVanillaNbt(class_2520 vanillaTag) {
        switch (vanillaTag.method_10711()) {
            case 1: {
                return new ByteData(((class_2481)vanillaTag).comp_3817());
            }
            case 2: {
                return new ShortData(((class_2516)vanillaTag).comp_3822());
            }
            case 3: {
                return new IntData(((class_2497)vanillaTag).comp_3820());
            }
            case 4: {
                return new LongData(((class_2503)vanillaTag).comp_3821());
            }
            case 5: {
                return new FloatData(((class_2494)vanillaTag).comp_3819());
            }
            case 6: {
                return new DoubleData(((class_2489)vanillaTag).comp_3818());
            }
            case 8: {
                return new StringData(((class_2519)vanillaTag).comp_3831());
            }
            case 7: {
                return new ByteArrayData(((class_2479)vanillaTag).method_10521());
            }
            case 11: {
                return new IntArrayData(((class_2495)vanillaTag).method_10588());
            }
            case 12: {
                return new LongArrayData(((class_2501)vanillaTag).method_10615());
            }
            case 10: {
                return DataConverterNbt.fromVanillaCompound((class_2487)vanillaTag);
            }
            case 9: {
                return DataConverterNbt.fromVanillaList((class_2499)vanillaTag);
            }
        }
        MaLiLib.LOGGER.warn("DataConverterNbt.fromVanillaCompound: Unknown NBT tag id {}", (Object)vanillaTag.method_10711());
        return null;
    }

    @Nullable
    public static ListData fromVanillaList(class_2499 vanillaList) {
        ListData list = new ListData(vanillaList.method_10711());
        for (int index = 0; index < vanillaList.size(); ++index) {
            class_2520 entry = (class_2520)vanillaList.get(index);
            if (entry.method_10711() == 0) {
                MaLiLib.LOGGER.warn("DataConverterNbt.fromVanillaList: Got TAG_End in a list at index {}", (Object)index);
                return null;
            }
            BaseData convertedTag = DataConverterNbt.fromVanillaNbt(entry);
            if (convertedTag == null) {
                return null;
            }
            list.add(convertedTag);
        }
        return list;
    }

    public static CompoundData fromVanillaCompound(class_2487 vanillaCompound) {
        CompoundData data = new CompoundData();
        for (String key : vanillaCompound.method_10541()) {
            BaseData convertedTag = DataConverterNbt.fromVanillaNbt(vanillaCompound.method_10580(key));
            if (convertedTag == null) continue;
            data.put(key, convertedTag);
        }
        return data;
    }

    @Nullable
    public static class_2520 toVanillaNbt(BaseData data) {
        switch (data.getType()) {
            case 1: {
                return class_2481.method_23233((byte)((ByteData)data).value);
            }
            case 2: {
                return class_2516.method_23254((short)((ShortData)data).value);
            }
            case 3: {
                return class_2497.method_23247((int)((IntData)data).value);
            }
            case 4: {
                return class_2503.method_23251((long)((LongData)data).value);
            }
            case 5: {
                return class_2494.method_23244((float)((FloatData)data).value);
            }
            case 6: {
                return class_2489.method_23241((double)((DoubleData)data).value);
            }
            case 8: {
                return class_2519.method_23256((String)((StringData)data).value);
            }
            case 7: {
                return new class_2479(((ByteArrayData)data).value);
            }
            case 11: {
                return new class_2495(((IntArrayData)data).value);
            }
            case 12: {
                return new class_2501(((LongArrayData)data).value);
            }
            case 10: {
                return DataConverterNbt.toVanillaCompound((CompoundData)data);
            }
            case 9: {
                return DataConverterNbt.toVanillaList((ListData)data);
            }
        }
        MaLiLib.LOGGER.warn("DataConverterNbt.toVanillaNbt: Unknown NBT tag id {}", (Object)data.getType());
        return null;
    }

    @Nullable
    public static class_2499 toVanillaList(ListData listData) {
        class_2499 list = new class_2499();
        for (int index = 0; index < listData.size(); ++index) {
            BaseData entry = listData.get(index);
            if (entry.getType() == 0) {
                MaLiLib.LOGGER.warn("DataConverterNbt.toVanillaList: Got TAG_End in a list at index {}", (Object)index);
                return null;
            }
            class_2520 convertedTag = DataConverterNbt.toVanillaNbt(entry);
            if (convertedTag == null) {
                MaLiLib.LOGGER.warn("DataConverterNbt.toVanillaList: Got a null tag in a list at index {}", (Object)index);
                return null;
            }
            list.add((Object)convertedTag);
        }
        return list;
    }

    public static class_2487 toVanillaCompound(CompoundData compoundData) {
        class_2487 tag = new class_2487();
        for (String key : compoundData.getKeys()) {
            class_2520 convertedTag = DataConverterNbt.toVanillaNbt(compoundData.getData(key).orElse(null));
            if (convertedTag == null) {
                MaLiLib.LOGGER.warn("DataConverterNbt.toVanillaCompound: Got a null tag in a compound with key {}", (Object)key);
                return null;
            }
            tag.method_10566(key, convertedTag);
        }
        return tag;
    }
}

