/*
 * Decompiled with CFR 0.152.
 */
package io.github.reserveword.imblocker.common;

import com.sun.jna.Platform;
import io.github.reserveword.imblocker.common.EnglishState;
import io.github.reserveword.imblocker.common.EnglishStateImpl;
import io.github.reserveword.imblocker.common.IMBlockerConfig;
import java.util.ArrayList;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.ConfigHolder;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.annotation.ConfigEntry;
import me.shedaniel.clothconfig2.gui.AbstractConfigScreen;
import net.minecraft.class_437;

@Config(name="imblocker")
public class IMBlockerAutoConfig
extends IMBlockerConfig
implements ConfigData {
    @ConfigEntry.Gui.CollapsibleObject(startExpanded=true)
    BasicSettings basicSettings = new BasicSettings();
    @ConfigEntry.Gui.CollapsibleObject(startExpanded=true)
    AdvanceSettings advanceSettings = new AdvanceSettings();
    @ConfigEntry.Gui.CollapsibleObject
    WindowsCompatibilitySettings windowsCompatibilitySettings = new WindowsCompatibilitySettings();
    @ConfigEntry.Gui.CollapsibleObject
    LinuxCompatibilitySettings linuxCompatibilitySettings = new LinuxCompatibilitySettings();

    public void validatePostLoad() {
        this.reloadScreenWhitelist(this.basicSettings.screenWhitelist);
    }

    @Override
    public void recoverScreen(String screenClsName) {
        if (!this.basicSettings.recoveredScreens.contains(screenClsName)) {
            this.basicSettings.recoveredScreens.add(screenClsName);
        }
    }

    @Override
    public boolean isScreenRecoveringEnabled() {
        return this.basicSettings.enableScreenRecovering;
    }

    @Override
    public EnglishStateImpl getEnglishStateImpl() {
        return this.basicSettings.englishStateImpl;
    }

    @Override
    public EnglishState getPrimaryEnglishState() {
        return this.basicSettings.primaryEnglishState;
    }

    @Override
    public boolean isCharSimulationEnabled() {
        return this.advanceSettings.enableCharSimulation;
    }

    @Override
    public boolean isConversionStatusApiEnabled() {
        return this.windowsCompatibilitySettings.enableConversionStatusApi;
    }

    @Override
    public boolean isCursorPositionTrackingEnabled() {
        return this.windowsCompatibilitySettings.enableCursorPositionTracking;
    }

    @Override
    public boolean isCompositionFontTweaksEnabled() {
        return this.windowsCompatibilitySettings.enableCompositionFontTweaks;
    }

    @Override
    public boolean isLinuxKeyboardPatchEnabled() {
        return this.linuxCompatibilitySettings.enableKeyboardPatch;
    }

    @Override
    public String getIBusOnArgName() {
        return this.linuxCompatibilitySettings.ibusOnArgName;
    }

    @Override
    public String getIBusOffArgName() {
        return this.linuxCompatibilitySettings.ibusOffArgName;
    }

    @Override
    public String getFcitx5OnArgName() {
        return this.linuxCompatibilitySettings.fcitx5OnArgName;
    }

    @Override
    public String getFcitx5OffArgName() {
        return this.linuxCompatibilitySettings.fcitx5OffArgName;
    }

    @Override
    public String getFcitx5OnStateName() {
        return this.linuxCompatibilitySettings.fcitx5OnStateName;
    }

    public static class_437 getConfigScreen(class_437 parent) {
        class_437 configScreen = (class_437)AutoConfig.getConfigScreen(IMBlockerAutoConfig.class, (class_437)parent).get();
        ConfigHolder configHolder = AutoConfig.getConfigHolder(IMBlockerAutoConfig.class);
        ((AbstractConfigScreen)configScreen).setSavingRunnable(() -> {
            configHolder.save();
            ((IMBlockerAutoConfig)configHolder.getConfig()).validatePostLoad();
        });
        return configScreen;
    }

    static class BasicSettings {
        @ConfigEntry.Gui.Tooltip
        ArrayList<String> screenWhitelist = new ArrayList<String>(IMBlockerConfig.defaultScreenWhitelist);
        boolean enableScreenRecovering = false;
        @ConfigEntry.Gui.Tooltip
        ArrayList<String> recoveredScreens = new ArrayList();
        @ConfigEntry.Gui.Tooltip(count=3)
        @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
        EnglishStateImpl englishStateImpl = Platform.isWindows() ? EnglishStateImpl.CONVERSION_STATUS : EnglishStateImpl.DISABLE_IM;
        @ConfigEntry.Gui.Tooltip(count=3)
        @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
        EnglishState primaryEnglishState = EnglishState.CJK;

        BasicSettings() {
        }
    }

    static class AdvanceSettings {
        @ConfigEntry.Gui.Tooltip(count=2)
        boolean enableCharSimulation = false;

        AdvanceSettings() {
        }
    }

    static class WindowsCompatibilitySettings {
        @ConfigEntry.Gui.Tooltip
        boolean enableConversionStatusApi = true;
        boolean enableCursorPositionTracking = true;
        boolean enableCompositionFontTweaks = true;

        WindowsCompatibilitySettings() {
        }
    }

    static class LinuxCompatibilitySettings {
        @ConfigEntry.Gui.Tooltip(count=2)
        boolean enableKeyboardPatch = true;
        @ConfigEntry.Gui.Tooltip
        String ibusOnArgName = "libpinyin";
        @ConfigEntry.Gui.Tooltip
        String ibusOffArgName = "xkb:us::eng";
        @ConfigEntry.Gui.Tooltip
        String fcitx5OnArgName = "-o";
        @ConfigEntry.Gui.Tooltip
        String fcitx5OffArgName = "-c";
        @ConfigEntry.Gui.Tooltip
        String fcitx5OnStateName = "2";

        LinuxCompatibilitySettings() {
        }
    }
}

