/*
 * Decompiled with CFR 0.152.
 */
package io.github.reserveword.imblocker.common.gui;

import imgui.ImGuiIO;
import io.github.reserveword.imblocker.common.ReflectionUtil;
import io.github.reserveword.imblocker.common.gui.FocusContainer;
import io.github.reserveword.imblocker.common.gui.FocusManager;

public class AxiomGuiMonitor {
    private static AxiomGuiMonitor instance;
    private final ImGuiIO axiomGuiAccessor;
    private boolean axiomGuiCaptureKeyboard = false;
    private boolean axiomTextFieldFocused = false;
    private final Class<?> axiomEditorUIClass;

    public AxiomGuiMonitor(ImGuiIO axiomGuiAccessor, Class<?> axiomEditorUIClass) {
        this.axiomGuiAccessor = axiomGuiAccessor;
        this.axiomEditorUIClass = axiomEditorUIClass;
    }

    public final void tick() {
        boolean isAxiomGuiFocused = this.axiomGuiAccessor.getWantCaptureKeyboard();
        boolean isAxiomTextFieldFocused = this.axiomGuiAccessor.getWantTextInput();
        if (this.axiomGuiCaptureKeyboard != isAxiomGuiFocused) {
            this.axiomGuiCaptureKeyboard = isAxiomGuiFocused;
            FocusManager.requestFocus(isAxiomGuiFocused ? FocusContainer.IMGUI : FocusContainer.MINECRAFT);
        }
        if (this.axiomTextFieldFocused != isAxiomTextFieldFocused) {
            this.axiomTextFieldFocused = isAxiomTextFieldFocused;
            if (isAxiomTextFieldFocused) {
                FocusContainer.IMGUI.setPreferredState(true);
            } else {
                FocusContainer.IMGUI.clearFocus();
                FocusContainer.IMGUI.setPreferredState(false);
            }
        }
    }

    public boolean isAxiomEditorShowing() {
        return ReflectionUtil.getFieldValue(this.axiomEditorUIClass, null, Boolean.TYPE, "enabled");
    }

    public int getGameContentOffsetX() {
        return ReflectionUtil.getFieldValue(this.axiomEditorUIClass, null, Integer.TYPE, "frameX");
    }

    public int getGameContentOffsetY() {
        return ReflectionUtil.getFieldValue(this.axiomEditorUIClass, null, Integer.TYPE, "frameY");
    }

    public static void createInstance(ImGuiIO axiomGuiAccessor, Class<?> axiomEditorUIClass) {
        instance = new AxiomGuiMonitor(axiomGuiAccessor, axiomEditorUIClass);
    }

    public static AxiomGuiMonitor getInstance() {
        return instance;
    }
}

