/*
 * Decompiled with CFR 0.152.
 */
package io.github.reserveword.imblocker.common.gui;

import io.github.reserveword.imblocker.common.IMBlockerConfig;
import io.github.reserveword.imblocker.common.IMBlockerCore;
import io.github.reserveword.imblocker.common.MathHelper;
import io.github.reserveword.imblocker.common.MinecraftClientUtil;
import io.github.reserveword.imblocker.common.gui.AxiomGuiMonitor;
import io.github.reserveword.imblocker.common.gui.Dimension;
import io.github.reserveword.imblocker.common.gui.FocusContainer;
import io.github.reserveword.imblocker.common.gui.FocusManager;
import io.github.reserveword.imblocker.common.gui.FocusableWidget;
import io.github.reserveword.imblocker.common.gui.MinecraftTextFieldWidget;
import io.github.reserveword.imblocker.common.gui.Point;
import io.github.reserveword.imblocker.common.gui.Rectangle;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Optional;

final class MinecraftFocusContext
extends FocusContainer {
    private static final boolean IS_AXIOM_LOADED = IMBlockerCore.hasMod("axiom");
    private final Map<FocusableWidget, Long> focusCandidates = new IdentityHashMap<FocusableWidget, Long>();
    private final Runnable locateFocusByCharSimulation = () -> {
        if (!this.focusCandidates.isEmpty()) {
            FocusManager.isTrackingFocus = true;
            try {
                MinecraftClientUtil.sendSafeCharForFocusTracking(0);
            }
            catch (Throwable e) {
                IMBlockerCore.LOGGER.warn("[IMBlocker] Failed to locate focus with char simulation");
            }
            if (!FocusManager.isFocusLocated) {
                this.restoreContainerFocus();
            }
            FocusManager.isTrackingFocus = false;
            FocusManager.isFocusLocated = false;
        }
    };

    MinecraftFocusContext() {
        super(true);
    }

    @Override
    public void requestFocus(FocusableWidget toFocus) {
        this.focusCandidates.put(toFocus, System.nanoTime());
        this.locateRealFocus();
    }

    @Override
    public void locateRealFocus() {
        if (IMBlockerConfig.INSTANCE.isCharSimulationEnabled()) {
            IMBlockerCore.invokeLater(this.locateFocusByCharSimulation);
        } else {
            Optional<FocusableWidget> promotedFocusCandidate = this.focusCandidates.keySet().stream().filter(FocusableWidget::isRenderable).max((o1, o2) -> MathHelper.clampLong(this.focusCandidates.get(o1) - this.focusCandidates.get(o2)));
            if (promotedFocusCandidate.isPresent()) {
                this.switchFocus(promotedFocusCandidate.get());
            } else {
                this.restoreContainerFocus();
            }
        }
    }

    private void verifyFocus() {
        assert (this.focusCandidates.containsKey(this.focusedWidget));
    }

    @Override
    public void removeFocus(FocusableWidget toRemove) {
        if (this.focusCandidates.containsKey(toRemove)) {
            this.focusCandidates.remove(toRemove);
            if (this.focusCandidates.isEmpty()) {
                this.restoreContainerFocus();
            } else {
                this.locateRealFocus();
            }
        }
    }

    @Override
    public void switchFocus(FocusableWidget toFocus) {
        if (FocusManager.isTrackingFocus) {
            FocusManager.isFocusLocated = true;
        }
        super.switchFocus(toFocus);
        this.verifyFocus();
    }

    @Override
    public void clearFocus() {
        this.focusCandidates.clear();
        this.restoreContainerFocus();
    }

    @Override
    public void checkFocusCandidatesVisibility(long lastGameRenderTime) {
        this.focusCandidates.keySet().forEach(focusCandidate -> {
            if (focusCandidate instanceof MinecraftTextFieldWidget) {
                ((MinecraftTextFieldWidget)focusCandidate).checkVisibility(lastGameRenderTime);
            }
        });
    }

    @Override
    public Rectangle getBoundsAbs() {
        AxiomGuiMonitor axiomMonitor;
        int x = 0;
        int y = 0;
        Dimension contentSize = MinecraftClientUtil.getContentSize();
        if (IS_AXIOM_LOADED && (axiomMonitor = AxiomGuiMonitor.getInstance()) != null && axiomMonitor.isAxiomEditorShowing()) {
            x = axiomMonitor.getGameContentOffsetX();
            y = axiomMonitor.getGameContentOffsetY();
        }
        return new Rectangle(x, y, contentSize.width(), contentSize.height());
    }

    @Override
    public Point getCaretPos() {
        Dimension contentSize = MinecraftClientUtil.getContentSize();
        return new Point(contentSize.width() / 3, contentSize.height() / 2);
    }
}

