/*
 * Decompiled with CFR 0.152.
 */
package io.github.reserveword.imblocker.common.gui;

import io.github.reserveword.imblocker.common.IMBlockerConfig;
import io.github.reserveword.imblocker.common.MinecraftClientUtil;
import io.github.reserveword.imblocker.common.StringUtil;
import io.github.reserveword.imblocker.common.gui.MinecraftAbstractTextInputWidget;
import io.github.reserveword.imblocker.common.gui.Point;
import io.github.reserveword.imblocker.common.gui.SinglelineCursorInfo;

public interface MinecraftTextFieldWidget
extends MinecraftAbstractTextInputWidget<SinglelineCursorInfo> {
    default public void setPreferredEnglishState(boolean state) {
    }

    default public boolean getPrimaryEnglishState() {
        return IMBlockerConfig.INSTANCE.getPrimaryEnglishState().getBoolean();
    }

    @Override
    default public Point getCaretPos() {
        SinglelineCursorInfo cursorInfo = (SinglelineCursorInfo)this.getCursorInfo();
        if (cursorInfo == null) {
            return Point.TOP_LEFT;
        }
        int caretX = (cursorInfo.hasBorder ? this.getPaddingX() : 0) + MinecraftClientUtil.getStringWidth(StringUtil.getSubstring(cursorInfo.text, cursorInfo.cursorLineBeginIndex, cursorInfo.cursor));
        int caretY = cursorInfo.hasBorder ? (cursorInfo.widgetHeight - this.getFontHeight()) / 2 : 0;
        return new Point(this.getGuiScale(), caretX, caretY);
    }

    default public int getPaddingX() {
        return 4;
    }

    default public void checkVisibility(long lastGameRenderTime) {
    }
}

