/*
 * Decompiled with CFR 0.152.
 */
package io.github.reserveword.imblocker.mixin;

import io.github.reserveword.imblocker.common.IMBlockerConfig;
import io.github.reserveword.imblocker.common.IMBlockerCore;
import io.github.reserveword.imblocker.common.gui.FocusContainer;
import io.github.reserveword.imblocker.common.gui.FocusManager;
import net.minecraft.class_1041;
import net.minecraft.class_310;
import net.minecraft.class_437;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_310.class})
public abstract class MinecraftClientMixin {
    @Shadow
    private class_1041 field_1704;
    @Unique
    private long lastGameRenderTime = 0L;

    @Inject(method={"method_15995(Z)V"}, at={@At(value="HEAD")})
    public void onWindowFocusChanged(boolean isFocused, CallbackInfo ci) {
        FocusManager.setWindowFocused(isFocused);
    }

    @Inject(method={"method_1507(Lnet/minecraft/class_437;)V"}, at={@At(value="HEAD")})
    public void onScreenChanged(class_437 screen, CallbackInfo ci) {
        if (IMBlockerConfig.INSTANCE.isScreenRecoveringEnabled() && screen != null) {
            IMBlockerConfig.INSTANCE.recoverScreen(screen.getClass().getName());
        }
        FocusContainer.MINECRAFT.clearFocus();
        FocusContainer.MINECRAFT.setPreferredState(this.isScreenInWhiteList(screen));
    }

    @Inject(method={"method_1523(Z)V"}, at={@At(value="HEAD")})
    public void runPreRenderTasks(boolean tick, CallbackInfo ci) {
        IMBlockerCore.renderStart();
    }

    @Inject(method={"method_1523(Z)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/class_757;method_3192(Lnet/minecraft/class_9779;Z)V")})
    public void recordGameRenderStartTime(boolean tick, CallbackInfo ci) {
        this.lastGameRenderTime = System.nanoTime();
        FocusManager.isGameRendering = true;
    }

    @Inject(method={"method_1523(Z)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/class_757;method_3192(Lnet/minecraft/class_9779;Z)V", shift=At.Shift.AFTER)})
    public void captureGameRenderEnd(boolean tick, CallbackInfo ci) {
        if (FocusManager.isGameRendering) {
            FocusManager.isGameRendering = false;
            FocusContainer.MINECRAFT.checkFocusCandidatesVisibility(this.lastGameRenderTime);
        }
    }

    private boolean isScreenInWhiteList(class_437 screen) {
        return IMBlockerConfig.INSTANCE.isScreenInWhitelist(screen);
    }
}

