/*
 * Decompiled with CFR 0.152.
 */
package io.github.reserveword.imblocker.mixin.compat;

import gg.essential.gui.common.input.AbstractTextInput;
import io.github.reserveword.imblocker.common.IMManager;
import io.github.reserveword.imblocker.common.gui.FocusContainer;
import io.github.reserveword.imblocker.common.gui.FocusManager;
import io.github.reserveword.imblocker.common.gui.Point;
import io.github.reserveword.imblocker.mixin.compat.EssentialUIComponentMixin;
import kotlin.Pair;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Pseudo;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Pseudo
@Mixin(targets={"gg/essential/gui/common/input/AbstractTextInput"}, remap=false)
public abstract class EssentialAbstractTextInputMixin
extends EssentialUIComponentMixin {
    @Shadow
    private AbstractTextInput.LinePosition cursor;
    @Shadow
    private boolean active;
    @Shadow
    private float lineHeight;

    @Override
    public void onFocusGained(CallbackInfo ci) {
        this.imblocker$onFocusGained();
    }

    @Override
    public void onFocusLost(CallbackInfo ci) {
        this.imblocker$onFocusLost();
    }

    @Override
    public void checkFocusTracking(char c, int keyCode, CallbackInfo ci) {
        if (FocusManager.isTrackingFocus) {
            if (this.active) {
                FocusContainer.MINECRAFT.switchFocus(this);
            }
            ci.cancel();
        }
    }

    @Inject(method={"setCursor"}, at={@At(value="TAIL")})
    public void onCursorChanged(AbstractTextInput.LinePosition value, CallbackInfo ci) {
        IMManager.updateCompositionWindowPos();
    }

    @Inject(method={"setHorizontalScrollingOffset"}, at={@At(value="TAIL")})
    public void onHorizontalScrolling(float f, CallbackInfo ci) {
        IMManager.updateCompositionWindowPos();
    }

    @Inject(method={"setTargetVerticalScrollingOffset"}, at={@At(value="TAIL")})
    public void onVerticalScrolling(float f, CallbackInfo ci) {
        IMManager.updateCompositionWindowPos();
    }

    @Override
    public Point getCaretPos() {
        Pair caretPos = this.cursor.toScreenPos();
        return new Point(this.getGuiScale(), ((Float)caretPos.getFirst()).intValue(), ((Float)caretPos.getSecond()).intValue());
    }

    @Override
    public int getFontHeight() {
        return (int)(this.lineHeight * this.getTextScale());
    }
}

