/*
 * Decompiled with CFR 0.152.
 */
package io.github.reserveword.imblocker.mixin.compat;

import io.github.reserveword.imblocker.common.IMManager;
import io.github.reserveword.imblocker.common.gui.FocusContainer;
import io.github.reserveword.imblocker.common.gui.FocusManager;
import io.github.reserveword.imblocker.common.gui.Point;
import io.github.reserveword.imblocker.mixin.compat.MeteorWidgetMixin;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Pseudo;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Pseudo
@Mixin(targets={"meteordevelopment/meteorclient/gui/widgets/input/WTextBox"}, remap=false)
public abstract class MeteorTextFieldMixin
extends MeteorWidgetMixin {
    @Shadow
    protected int cursor;
    @Shadow
    protected double textStart;
    @Shadow
    protected boolean focused;

    @Shadow
    protected abstract double getTextWidth(int var1);

    @Inject(method={"setFocused"}, at={@At(value="TAIL")})
    public void focusChanged(boolean isFocused, CallbackInfo ci) {
        this.imblocker$onFocusChanged(this.focused);
    }

    @Inject(method={"onCharTyped"}, at={@At(value="HEAD")}, cancellable=true)
    public void checkFocusTracking(char c, CallbackInfoReturnable<Boolean> cir) {
        if (FocusManager.isTrackingFocus) {
            if (this.focused) {
                FocusContainer.MINECRAFT.switchFocus(this);
                cir.setReturnValue((Object)true);
            } else {
                cir.setReturnValue((Object)false);
            }
        }
    }

    @Inject(method={"cursorChanged"}, at={@At(value="TAIL")})
    public void onCursorChanged(CallbackInfo ci) {
        IMManager.updateCompositionWindowPos();
    }

    @Inject(method={"move"}, at={@At(value="TAIL")})
    public void handlePosChanged(double x, double y, CallbackInfo ci) {
        this.imblocker$onBoundsChanged();
    }

    @Override
    public void onLayoutWidget(CallbackInfo ci) {
        this.imblocker$onBoundsChanged();
        IMManager.updateCompositionFontSize();
    }

    @Override
    public Point getCaretPos() {
        int caretX = (int)(this.getTextWidth(this.cursor) - this.textStart + this.pad());
        return new Point(caretX, (int)(this.height / 3.5));
    }

    @Override
    public int getFontHeight() {
        return (int)(this.height * 3.0 / 7.0);
    }
}

