/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.info.world;

import fi.dy.masa.minihud.config.InfoToggle;
import fi.dy.masa.minihud.info.InfoLine;
import fi.dy.masa.minihud.util.MiscUtils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.class_1937;
import net.minecraft.class_2338;

public class InfoLineSlimeChunk
extends InfoLine {
    private static final String SLIME_KEY = "minihud.info_line.slime_chunk";

    public InfoLineSlimeChunk(InfoToggle type) {
        super(type);
    }

    public InfoLineSlimeChunk() {
        this(InfoToggle.SLIME_CHUNK);
    }

    @Override
    public boolean succeededType() {
        return false;
    }

    @Override
    public List<InfoLine.Entry> parse(@Nonnull InfoLine.Context ctx) {
        if (this.getClientWorld() == null || ctx.pos() == null) {
            return null;
        }
        return this.parseBlockPos(ctx.world() == null ? this.getClientWorld() : ctx.world(), ctx.pos());
    }

    @Override
    public List<InfoLine.Entry> parseBlockPos(@Nonnull class_1937 world, @Nonnull class_2338 pos) {
        String result;
        ArrayList<InfoLine.Entry> list = new ArrayList<InfoLine.Entry>();
        if (!MiscUtils.isOverworld(world)) {
            return null;
        }
        if (this.getHudData().isWorldSeedKnown(world)) {
            long seed = this.getHudData().getWorldSeed(world);
            result = MiscUtils.canSlimeSpawnAt(pos.method_10263(), pos.method_10260(), seed) ? this.qt("minihud.info_line.slime_chunk.yes", new Object[0]) : this.qt("minihud.info_line.slime_chunk.no", new Object[0]);
        } else {
            result = this.qt("minihud.info_line.slime_chunk.no_seed", new Object[0]);
        }
        list.add(this.translate(SLIME_KEY, result));
        return list;
    }
}

