/*
 * Decompiled with CFR 0.152.
 */
package dlovin.inventoryhud;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import dlovin.inventoryhud.config.InvConfig;
import dlovin.inventoryhud.config.InvConfigManager;
import dlovin.inventoryhud.gui.InventoryHUDGui;
import dlovin.inventoryhud.gui.layers.ArmorLayer;
import dlovin.inventoryhud.gui.layers.InvHudLayer;
import dlovin.inventoryhud.gui.layers.InventoryLayer;
import dlovin.inventoryhud.gui.layers.PotionLayer;
import dlovin.inventoryhud.keybinds.KeyBinds;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.ClientModInitializer;

public class InventoryHUD
implements ClientModInitializer {
    private static InventoryHUD instance;
    private InventoryHUDGui invhudGUI;
    public static final String modid = "inventoryhud";
    public static final Gson GSON;
    public static boolean InvHUD;
    public static boolean PotHUD;
    public static boolean ArmHUD;
    public boolean notified = false;
    private final List<InvHudLayer> layers = new ArrayList<InvHudLayer>();

    public static InvConfig getConfig() {
        return InvConfigManager.getConfig();
    }

    public static void save() {
        InvConfigManager.save();
    }

    public static void log(String st) {
        System.out.println("[InventoryHUD+] " + st);
    }

    public void onInitializeClient() {
        InvConfigManager.initializeConfig();
        InvHUD = InvConfigManager.getConfig().getInv();
        PotHUD = InvConfigManager.getConfig().getPot();
        ArmHUD = InvConfigManager.getConfig().getArm();
        KeyBinds.initialize();
        instance = this;
        System.out.println("Inventory HUD + has been initialized!");
    }

    public List<InvHudLayer> initLayers() {
        this.layers.add(new PotionLayer());
        this.layers.add(new ArmorLayer());
        this.layers.add(new InventoryLayer());
        this.invhudGUI = new InventoryHUDGui();
        this.layers.forEach(InvHudLayer::init);
        return this.layers;
    }

    public List<InvHudLayer> getLayers() {
        return this.layers;
    }

    public static InventoryHUD getInstance() {
        return instance;
    }

    public InventoryHUDGui getInvhudGUI() {
        return this.invhudGUI;
    }

    static {
        GSON = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).setPrettyPrinting().create();
        InvHUD = false;
        PotHUD = false;
        ArmHUD = false;
    }
}

