/*
 * Decompiled with CFR 0.152.
 */
package dlovin.inventoryhud.config.widgets;

import dlovin.inventoryhud.config.widgets.ButtonWidget;
import dlovin.inventoryhud.utils.RenderHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_11909;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_9848;

public class ConfigWidget
extends ButtonWidget {
    private final class_310 mc;
    protected class_2960 resourceLocation;
    protected class_2960 icon;
    protected float texOffX;
    protected float texOffY;
    protected float scale;
    protected int color;
    protected int textColor = class_9848.method_61330((int)255, (int)-1);
    protected boolean isShow;
    protected boolean isDisableable;
    protected boolean snapable;
    private final List<ConfigWidgetPosListener> posListeners = new ArrayList<ConfigWidgetPosListener>();
    private double d_x;
    private double d_y;

    public ConfigWidget(int xIn, int yIn, int widthIn, int heightIn, float scaleIn, boolean snapable, String msg, boolean isShow, boolean isDisableable) {
        this(xIn, yIn, widthIn, heightIn, scaleIn, msg, isShow, isDisableable);
        this.snapable = snapable;
    }

    public ConfigWidget(int xIn, int yIn, int widthIn, int heightIn, float scaleIn, String msg, boolean isShow) {
        this(xIn, yIn, widthIn, heightIn, scaleIn, msg, isShow, true);
    }

    public ConfigWidget(int xIn, int yIn, int widthIn, int heightIn, float scaleIn, String msg, boolean isShow, boolean isDisableable) {
        super(xIn, yIn, (int)((float)widthIn * scaleIn), (int)((float)heightIn * scaleIn), msg);
        this.d_x = xIn;
        this.d_y = yIn;
        this.isShow = isShow;
        this.scale = scaleIn;
        this.mc = class_310.method_1551();
        this.isDisableable = isDisableable;
        this.snapable = true;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void addPosListener(ConfigWidgetPosListener act) {
        this.posListeners.add(act);
    }

    public boolean getShow() {
        return this.isShow;
    }

    public void initTextureValues(int xTexStartIn, int yTexStartIn, int color, class_2960 resourceLocationIn) {
        this.initTextureValues(xTexStartIn, yTexStartIn, color, resourceLocationIn, null);
    }

    public void initTextureValues(int xTexStartIn, int yTexStartIn, int color, class_2960 resourceLocationIn, class_2960 iconIn) {
        this.resourceLocation = resourceLocationIn;
        this.texOffX = (float)xTexStartIn * this.scale;
        this.texOffY = (float)yTexStartIn * this.scale;
        this.color = color;
        this.icon = iconIn;
    }

    private void renderBg(class_332 context, class_2960 tex) {
        RenderHelper.drawTextureWithBorder(context, tex, this.x, this.y, this.width, this.height, 3, 16, 256, this.color);
    }

    @Override
    public void method_25394(class_332 context, int mx, int my, float pt) {
        super.method_25394(context, mx, my, pt);
        this.renderBg(context, this.resourceLocation);
        if (this.icon != null) {
            int size = this.width - 2;
            RenderHelper.drawTexture(context, this.icon, this.x + this.width / 2 - size / 2, this.y + this.height / 2 - size / 2, size, size);
        }
        if (this.isDisableable) {
            if (this.isShow) {
                RenderHelper.drawTexture(context, this.resourceLocation, this.x + this.width - 12, this.y + 2, 162, 0, 10, 10, 256, 256);
            } else {
                RenderHelper.drawTexture(context, this.resourceLocation, this.x + this.width - 12, this.y + 2, 172, 0, 10, 10, 256, 256);
            }
        }
        this.drawMiddleAlignedString(context, this.mc.field_1772, this.getMessage(), this.x + this.width / 2, this.y + this.height / 2 - 3);
    }

    @Override
    public boolean method_25406(class_11909 event) {
        this.d_x = this.x;
        this.d_y = this.y;
        return this.hovered;
    }

    public void onRelease(double _p_onRelease_1_, double _p_onRelease_3_) {
        this.d_x = this.x;
        this.d_y = this.y;
    }

    @Override
    public boolean method_25402(class_11909 event, boolean doubleClick) {
        if (this.hovered && event.method_74245() == 0) {
            if (this.isDisableable && event.comp_4798() >= (double)(this.x + this.width - 12) && event.comp_4798() < (double)(this.width + this.x - 2) && event.comp_4799() >= (double)(this.y + 2) && event.comp_4799() < (double)(this.y + 12)) {
                this.playDownSound(this.mc.method_1483());
                this.isShow = !this.isShow;
                for (ButtonWidget.ButtonClickListener hl : this.listeners) {
                    hl.onClick(this);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean method_25403(class_11909 event, double deltaX, double deltaY) {
        if (event.method_74245() == 0) {
            this.onDrag(event.comp_4798(), event.comp_4799(), deltaX, deltaY);
            return true;
        }
        return false;
    }

    protected void onDrag(double mx, double my, double dragX, double dragY) {
        this.d_x += dragX;
        this.d_y += dragY;
        if (!this.snapable) {
            this.clampX(this.d_x, 0, this.mc.field_1755.field_22789 - this.width);
            this.clampY(this.d_y, 0, this.mc.field_1755.field_22790 - this.height);
        } else {
            if (this.d_x + (double)(this.width / 2) <= (double)(this.mc.field_1755.field_22789 / 2 - 10) || this.d_x + (double)(this.width / 2) >= (double)(this.mc.field_1755.field_22789 / 2 + 10)) {
                this.clampX(this.d_x, 0, this.mc.field_1755.field_22789 - this.width);
            } else {
                this.x = this.mc.field_1755.field_22789 / 2 - this.width / 2;
            }
            if (this.d_y + (double)(this.height / 2) <= (double)(this.mc.field_1755.field_22790 / 2 - 10) || this.d_y + (double)(this.height / 2) >= (double)(this.mc.field_1755.field_22790 / 2 + 10)) {
                this.clampY(this.d_y, 0, this.mc.field_1755.field_22790 - this.height);
            } else {
                this.y = this.mc.field_1755.field_22790 / 2 - this.height / 2;
            }
        }
        for (ConfigWidgetPosListener hl : this.posListeners) {
            hl.onPosChanged(this);
        }
    }

    private void clampX(double dx, int min, int max) {
        if (dx < (double)min) {
            dx = min;
        } else if (dx > (double)max) {
            dx = max;
        }
        this.x = (int)dx;
    }

    private void clampY(double dy, int min, int max) {
        if (dy < (double)min) {
            dy = min;
        } else if (dy > (double)max) {
            dy = max;
        }
        this.y = (int)dy;
    }

    private void drawMiddleAlignedString(class_332 context, class_327 fontRenderer, String text, int x, int y) {
        context.method_51433(fontRenderer, text, x - fontRenderer.method_1727(text) / 2, y, this.textColor, true);
    }

    public static interface ConfigWidgetPosListener {
        public void onPosChanged(ConfigWidget var1);
    }
}

