/*
 * Decompiled with CFR 0.152.
 */
package troy.autofish;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1536;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1787;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_310;
import net.minecraft.class_3544;
import net.minecraft.class_7439;
import net.minecraft.class_746;
import org.apache.commons.lang3.StringUtils;
import troy.autofish.FabricModAutofish;
import troy.autofish.monitor.FishMonitorMP;
import troy.autofish.monitor.FishMonitorMPMotion;
import troy.autofish.monitor.FishMonitorMPSound;
import troy.autofish.scheduler.ActionType;

public class Autofish {
    private class_310 client;
    private FabricModAutofish modAutofish;
    private FishMonitorMP fishMonitorMP;
    private boolean hookExists = false;
    private boolean alreadyAlertOP = false;
    private boolean alreadyPassOP = false;
    private long hookRemovedAt = 0L;
    public long timeMillis = 0L;

    public Autofish(FabricModAutofish modAutofish) {
        this.modAutofish = modAutofish;
        this.client = class_310.method_1551();
        this.setDetection();
        modAutofish.getScheduler().scheduleRepeatingAction(10000L, () -> {
            if (!modAutofish.getConfig().isPersistentMode()) {
                return;
            }
            if (this.shouldPreventBreak()) {
                return;
            }
            if (!this.isHoldingFishingRod()) {
                return;
            }
            if (this.hookExists) {
                if (this.isBobberInWater()) {
                    return;
                }
                this.useRod();
            }
            if (modAutofish.getScheduler().isRecastQueued()) {
                return;
            }
            this.useRod();
        });
    }

    public void tick(class_310 client) {
        if (client.field_1687 != null && client.field_1724 != null && this.modAutofish.getConfig().isAutofishEnabled()) {
            this.timeMillis = class_156.method_658();
            if (this.isHoldingFishingRod()) {
                if (client.field_1724.field_7513 != null) {
                    this.hookExists = true;
                    if (this.shouldUseMPDetection()) {
                        this.fishMonitorMP.hookTick(this, client, client.field_1724.field_7513);
                    }
                } else {
                    this.removeHook();
                }
            } else {
                this.removeHook();
            }
        }
    }

    public void tickFishingLogic(class_1297 owner, int ticksCatchable) {
        this.client.execute(() -> {
            if (this.modAutofish.getConfig().isAutofishEnabled() && !this.shouldUseMPDetection() && this.client.field_1724 != null && this.client.field_1724.field_7513 != null && ticksCatchable > 0 && owner.method_5667().compareTo(this.client.field_1724.method_5667()) == 0) {
                this.catchFish();
            }
        });
    }

    public void handlePacket(class_2596<?> packet) {
        if (this.modAutofish.getConfig().isAutofishEnabled() && this.shouldUseMPDetection()) {
            this.fishMonitorMP.handlePacket(this, packet, this.client);
        }
    }

    public void handleChat(class_7439 packet) {
        if (this.modAutofish.getConfig().isAutofishEnabled() && !this.client.method_1542() && this.isHoldingFishingRod() && (this.hookExists || this.timeMillis - this.hookRemovedAt < 2000L)) {
            if (StringUtils.deleteWhitespace((String)this.modAutofish.getConfig().getClearLagRegex()).isEmpty()) {
                return;
            }
            Matcher matcher = Pattern.compile(this.modAutofish.getConfig().getClearLagRegex(), 2).matcher(class_3544.method_15440((String)packet.comp_763().getString()));
            if (matcher.find()) {
                this.queueRecast();
            }
        }
    }

    public void catchFish() {
        if (!this.modAutofish.getScheduler().isRecastQueued()) {
            this.modAutofish.getScheduler().onFishCaught();
            if (this.client.field_1724 != null) {
                this.detectOpenWater(this.client.field_1724.field_7513);
            }
            this.queueRodSwitch();
            this.queueRecast();
            this.modAutofish.getScheduler().scheduleAction(ActionType.REEL_IN, this.modAutofish.getConfig().getReelInDelay(), this::useRod);
        }
    }

    public void queueRecast() {
        this.modAutofish.getScheduler().scheduleAction(ActionType.RECAST, this.getRandomDelay() + this.modAutofish.getConfig().getReelInDelay(), () -> {
            if (this.hookExists) {
                return;
            }
            if (!this.isHoldingFishingRod()) {
                return;
            }
            if (this.shouldPreventBreak()) {
                return;
            }
            this.useRod();
        });
    }

    private void queueRodSwitch() {
        this.modAutofish.getScheduler().scheduleAction(ActionType.ROD_SWITCH, (long)((double)this.getRandomDelay() * 0.83) + this.modAutofish.getConfig().getReelInDelay(), () -> {
            if (!this.modAutofish.getConfig().isMultiRod()) {
                return;
            }
            this.switchToFirstRod(this.client.field_1724);
        });
    }

    private void detectOpenWater(class_1536 bobber) {
        if (!this.modAutofish.getConfig().isOpenWaterDetectEnabled()) {
            return;
        }
        int x = bobber.method_31477();
        int y = bobber.method_31478();
        int z = bobber.method_31479();
        boolean flag = true;
        for (int yi = -2; yi <= 2; ++yi) {
            if (class_2338.method_17962((int)(x - 2), (int)(y + yi), (int)(z - 2), (int)(x + 2), (int)(y + yi), (int)(z + 2)).allMatch(blockPos -> bobber.method_73183().method_8320(blockPos).method_26204() == class_2246.field_10382) || class_2338.method_17962((int)(x - 2), (int)(y + yi), (int)(z - 2), (int)(x + 2), (int)(y + yi), (int)(z + 2)).allMatch(blockPos -> bobber.method_73183().method_8320(blockPos).method_26204() == class_2246.field_10124 || bobber.method_73183().method_8320(blockPos).method_26204() == class_2246.field_10588)) continue;
            if (!this.alreadyAlertOP) {
                Objects.requireNonNull(bobber.method_6947()).method_7353((class_2561)class_2561.method_43471((String)"info.autofish.open_water_detection.fail"), true);
                this.alreadyAlertOP = true;
                this.alreadyPassOP = false;
            }
            flag = false;
        }
        if (flag && !this.alreadyPassOP) {
            Objects.requireNonNull(bobber.method_6947()).method_7353((class_2561)class_2561.method_43471((String)"info.autofish.open_water_detection.success"), true);
            this.alreadyPassOP = true;
            this.alreadyAlertOP = false;
        }
    }

    private void removeHook() {
        if (this.hookExists) {
            this.hookExists = false;
            this.hookRemovedAt = this.timeMillis;
            this.fishMonitorMP.handleHookRemoved();
        }
    }

    public void switchToFirstRod(class_746 player) {
        if (player != null) {
            class_1661 inventory = player.method_31548();
            for (int i = 0; i < inventory.method_67533().size(); ++i) {
                class_1799 slot = (class_1799)inventory.method_67533().get(i);
                if (slot.method_7909() != class_1802.field_8378 || i >= 9) continue;
                if (this.modAutofish.getConfig().isNoBreak()) {
                    if (slot.method_7919() >= slot.method_7936() - 1) continue;
                    inventory.method_61496(i);
                    return;
                }
                inventory.method_61496(i);
                return;
            }
        }
    }

    public boolean isBobberInWater() {
        if (this.client.field_1724 != null && this.client.field_1687 != null && this.client.field_1724.field_7513 != null) {
            return this.client.field_1687.method_8320(this.client.field_1724.field_7513.method_24515()).method_26204() == class_2246.field_10382;
        }
        return false;
    }

    public void useRod() {
        if (this.client.field_1724 != null && this.client.field_1687 != null) {
            class_1268 hand = this.getCorrectHand();
            class_1269 actionResult = null;
            if (this.client.field_1761 != null) {
                actionResult = this.client.field_1761.method_2919((class_1657)this.client.field_1724, hand);
            }
            if (actionResult != null && actionResult.method_23665()) {
                if (actionResult == class_1269.field_5812) {
                    this.client.field_1724.method_6104(hand);
                }
                this.client.field_1773.field_4012.method_3215(hand);
            }
        }
    }

    public boolean isHoldingFishingRod() {
        return this.isItemFishingRod(this.getHeldItem().method_7909());
    }

    private class_1268 getCorrectHand() {
        if (!this.modAutofish.getConfig().isMultiRod() && this.client.field_1724 != null && this.isItemFishingRod(this.client.field_1724.method_6079().method_7909())) {
            return class_1268.field_5810;
        }
        return class_1268.field_5808;
    }

    private class_1799 getHeldItem() {
        if (this.client.field_1724 == null) {
            return class_1799.field_8037;
        }
        if (!this.modAutofish.getConfig().isMultiRod() && this.isItemFishingRod(this.client.field_1724.method_6079().method_7909())) {
            return this.client.field_1724.method_6079();
        }
        return this.client.field_1724.method_6047();
    }

    private boolean isItemFishingRod(class_1792 item) {
        return item == class_1802.field_8378 || item instanceof class_1787;
    }

    public void setDetection() {
        this.fishMonitorMP = this.modAutofish.getConfig().isUseSoundDetection() ? new FishMonitorMPSound() : new FishMonitorMPMotion();
    }

    private boolean shouldUseMPDetection() {
        if (this.modAutofish.getConfig().isForceMPDetection()) {
            return true;
        }
        return !this.client.method_1542();
    }

    private long getRandomDelay() {
        return Math.random() >= 0.5 ? (long)((double)this.modAutofish.getConfig().getRecastDelay() * (1.0 - Math.random() * (double)this.modAutofish.getConfig().getRandomDelay() * 0.01)) : (long)((double)this.modAutofish.getConfig().getRecastDelay() * (1.0 + Math.random() * (double)this.modAutofish.getConfig().getRandomDelay() * 0.01));
    }

    private boolean shouldPreventBreak() {
        if (!this.modAutofish.getConfig().isNoBreak()) {
            return false;
        }
        class_1799 item = this.getHeldItem();
        return item != null && item.method_7919() == item.method_7936() - 1;
    }
}

