/*
 * Decompiled with CFR 0.152.
 */
package troy.autofish.scheduler;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_310;
import troy.autofish.FabricModAutofish;
import troy.autofish.scheduler.Action;
import troy.autofish.scheduler.ActionType;

public class AutofishScheduler {
    private FabricModAutofish modAutofish;
    private List<Action> queuedActions = new ArrayList<Action>();
    private List<Action> repeatingActions = new ArrayList<Action>();
    private boolean doesWorldExist;
    private float originalYaw = 0.0f;
    private float originalPitch = 0.0f;
    private boolean isTurning = false;
    private boolean turnLeft = true;

    public AutofishScheduler(FabricModAutofish modAutofish) {
        this.modAutofish = modAutofish;
    }

    public void tick(class_310 client) {
        if (client.field_1687 == null == this.doesWorldExist) {
            this.doesWorldExist = client.field_1687 != null;
            this.repeatingActions.forEach(Action::resetTimer);
        }
        if (!this.modAutofish.getConfig().isAutofishEnabled()) {
            this.queuedActions.clear();
            this.stopViewTurn();
        }
        if (client.field_1687 == null || client.field_1724 == null) {
            this.queuedActions.clear();
            return;
        }
        this.queuedActions.removeIf(Action::tick);
        this.repeatingActions.forEach(Action::tick);
    }

    public void onFishCaught() {
        if (this.modAutofish.getConfig().isAutofishEnabled() && !this.isTurning) {
            this.scheduleViewTurn();
        }
    }

    private void scheduleViewTurn() {
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null) {
            return;
        }
        if (!this.modAutofish.getConfig().isAutoTurnView()) {
            return;
        }
        this.originalYaw = client.field_1724.method_36454();
        this.originalPitch = client.field_1724.method_36455();
        this.isTurning = true;
        this.scheduleAction(ActionType.TURN_VIEW, 0L, () -> {
            if (client.field_1724 != null) {
                float turnAngle = this.modAutofish.getConfig().getTurnAngle();
                if (!this.turnLeft) {
                    turnAngle = -turnAngle;
                }
                float targetYaw = client.field_1724.method_36454() + turnAngle;
                client.field_1724.method_36456(targetYaw);
            }
        });
        this.scheduleAction(ActionType.RESET_VIEW, this.modAutofish.getConfig().getTurnDuration(), () -> {
            if (this.isTurning) {
                this.isTurning = false;
                this.turnLeft = !this.turnLeft;
            }
        });
    }

    public boolean isViewTurning() {
        return this.isTurning;
    }

    public void stopViewTurn() {
        if (this.isTurning) {
            class_310 client = class_310.method_1551();
            if (client.field_1724 != null) {
                client.field_1724.method_36456(this.originalYaw);
                client.field_1724.method_36457(this.originalPitch);
            }
            this.isTurning = false;
            this.queuedActions.removeIf(action -> action.getActionType() == ActionType.TURN_VIEW || action.getActionType() == ActionType.RESET_VIEW);
        }
    }

    public void scheduleAction(ActionType actionType, long delay, Runnable runnable) {
        this.queuedActions.add(new Action(actionType, delay, runnable));
    }

    public void scheduleAction(Action action) {
        this.queuedActions.add(action);
    }

    public void scheduleRepeatingAction(long interval, Runnable runnable) {
        this.repeatingActions.add(new Action(ActionType.REPEATING_ACTION, interval, runnable));
    }

    public boolean isRecastQueued() {
        return this.queuedActions.stream().anyMatch(action -> action.getActionType() == ActionType.RECAST);
    }
}

