/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.itemscroller.event;

import fi.dy.masa.itemscroller.config.Configs;
import fi.dy.masa.itemscroller.recipes.RecipePattern;
import fi.dy.masa.itemscroller.recipes.RecipeStorage;
import fi.dy.masa.itemscroller.util.AccessorUtils;
import fi.dy.masa.itemscroller.util.ClickPacketBuffer;
import fi.dy.masa.itemscroller.util.InputUtils;
import fi.dy.masa.itemscroller.util.InventoryUtils;
import fi.dy.masa.malilib.render.InventoryOverlay;
import fi.dy.masa.malilib.render.RenderUtils;
import fi.dy.masa.malilib.util.GuiUtils;
import fi.dy.masa.malilib.util.StringUtils;
import java.util.Objects;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_465;

public class RenderEventHandler {
    private static final RenderEventHandler INSTANCE = new RenderEventHandler();
    private final class_310 mc = class_310.method_1551();
    private int recipeListX;
    private int recipeListY;
    private int recipesPerColumn;
    private int columnWidth;
    private int columns;
    private int numberTextWidth;
    private int gapColumn;
    private int entryHeight;
    private double scale;

    public static RenderEventHandler instance() {
        return INSTANCE;
    }

    public void renderRecipeView(class_332 drawContext, class_310 mc, double mouseX, double mouseY) {
        class_437 class_4372 = GuiUtils.getCurrentScreen();
        if (class_4372 instanceof class_465) {
            class_465 gui = (class_465)class_4372;
            if (InputUtils.isRecipeViewOpen()) {
                RecipeStorage recipes = RecipeStorage.getInstance();
                int first = recipes.getFirstVisibleRecipeId();
                int countPerPage = recipes.getRecipeCountPerPage();
                int lastOnPage = first + countPerPage - 1;
                this.calculateRecipePositions(gui);
                drawContext.method_51448().pushMatrix();
                drawContext.method_51448().translate((float)this.recipeListX, (float)this.recipeListY);
                drawContext.method_51448().scale((float)this.scale, (float)this.scale);
                String str = StringUtils.translate((String)"itemscroller.gui.label.recipe_page", (Object[])new Object[]{first / countPerPage + 1, recipes.getTotalRecipeCount() / countPerPage});
                drawContext.method_51433(mc.field_1772, str, 16, -12, -1061109568, false);
                int i = 0;
                for (int recipeId = first; recipeId <= lastOnPage; ++recipeId) {
                    class_1799 stack = recipes.getRecipe(recipeId).getResult();
                    boolean selected = recipeId == recipes.getSelection();
                    int row = i % this.recipesPerColumn;
                    int column = i / this.recipesPerColumn;
                    this.renderStoredRecipeStack(drawContext, stack, recipeId, row, column, gui, selected);
                    ++i;
                }
                if (Configs.Generic.CRAFTING_RENDER_RECIPE_ITEMS.getBooleanValue()) {
                    int recipeId = this.getHoveredRecipeId(mouseX, mouseY, recipes, gui);
                    RecipePattern recipe = recipeId >= 0 ? recipes.getRecipe(recipeId) : recipes.getSelectedRecipe();
                    this.renderRecipeItems(drawContext, recipe, recipes.getRecipeCountPerPage(), gui);
                }
                drawContext.method_51448().popMatrix();
            }
        }
    }

    public void onDrawScreenPost(class_332 drawContext, class_310 mc, double mouseX, double mouseY) {
        this.renderRecipeView(drawContext, mc, mouseX, mouseY);
        class_437 class_4372 = GuiUtils.getCurrentScreen();
        if (class_4372 instanceof class_465) {
            class_465 gui = (class_465)class_4372;
            int bufferedCount = ClickPacketBuffer.getBufferedActionsCount();
            if (bufferedCount > 0) {
                drawContext.method_51433(mc.field_1772, "Buffered slot clicks: " + bufferedCount, 10, 10, -3092272, false);
            }
            if (InputUtils.isRecipeViewOpen()) {
                RecipePattern recipe;
                class_1799 stack;
                RecipeStorage recipes = RecipeStorage.getInstance();
                int recipeId = this.getHoveredRecipeId(mouseX, mouseY, recipes, gui);
                drawContext.method_51448().pushMatrix();
                drawContext.method_51448().translate(0.0f, 0.0f);
                if (recipeId >= 0) {
                    RecipePattern recipe2 = recipes.getRecipe(recipeId);
                    this.renderHoverTooltip(drawContext, mouseX, mouseY, recipe2, gui);
                } else if (Configs.Generic.CRAFTING_RENDER_RECIPE_ITEMS.getBooleanValue() && !InventoryUtils.isStackEmpty(stack = this.getHoveredRecipeIngredient(mouseX, mouseY, recipe = recipes.getSelectedRecipe(), recipes.getRecipeCountPerPage(), gui))) {
                    InventoryOverlay.renderStackToolTip((class_332)drawContext, (int)((int)mouseX), (int)((int)mouseY), (class_1799)stack, (class_310)mc);
                }
                drawContext.method_51448().popMatrix();
            }
        }
    }

    private void calculateRecipePositions(class_465<?> gui) {
        RecipeStorage recipes = RecipeStorage.getInstance();
        int gapHorizontal = 2;
        int gapVertical = 2;
        int stackBaseHeight = 16;
        this.recipesPerColumn = 9;
        this.columns = (int)Math.ceil((double)recipes.getRecipeCountPerPage() / (double)this.recipesPerColumn);
        this.numberTextWidth = 12;
        this.gapColumn = 4;
        int usableHeight = GuiUtils.getScaledWindowHeight();
        int usableWidth = AccessorUtils.getGuiLeft(gui);
        double gapScaleVertical = 0.8888888888888888;
        int maxStackDimensionsVertical = (int)((double)usableHeight / ((double)this.recipesPerColumn + 1.2) * gapScaleVertical);
        double gapScaleHorizontal = 0.8888888888888888;
        int maxStackDimensionsHorizontal = (int)((double)(usableWidth - this.columns * (this.numberTextWidth + this.gapColumn)) / ((double)(this.columns + 3) + 0.8) * gapScaleHorizontal);
        int stackDimensions = Math.min(maxStackDimensionsVertical, maxStackDimensionsHorizontal);
        this.scale = (double)stackDimensions / 16.0;
        this.entryHeight = 18;
        this.recipeListX = usableWidth - (int)((double)(this.columns * (16 + this.numberTextWidth + this.gapColumn) + 2) * this.scale);
        this.recipeListY = (int)((double)this.entryHeight * this.scale);
        this.columnWidth = 16 + this.numberTextWidth + this.gapColumn;
    }

    private void renderHoverTooltip(class_332 drawContext, double mouseX, double mouseY, RecipePattern recipe, class_465<?> gui) {
        class_1799 stack = recipe.getResult();
        if (!InventoryUtils.isStackEmpty(stack)) {
            InventoryOverlay.renderStackToolTip((class_332)drawContext, (int)((int)mouseX), (int)((int)mouseY), (class_1799)stack, (class_310)this.mc);
        }
    }

    public int getHoveredRecipeId(double mouseX, double mouseY, RecipeStorage recipes, class_465<?> gui) {
        if (InputUtils.isRecipeViewOpen()) {
            this.calculateRecipePositions(gui);
            int stackDimensions = (int)(16.0 * this.scale);
            for (int column = 0; column < this.columns; ++column) {
                int startX = this.recipeListX + (int)((double)(column * this.columnWidth + this.gapColumn + this.numberTextWidth) * this.scale);
                if (!(mouseX >= (double)startX) || !(mouseX <= (double)(startX + stackDimensions))) continue;
                for (int row = 0; row < this.recipesPerColumn; ++row) {
                    int startY = this.recipeListY + (int)((double)(row * this.entryHeight) * this.scale);
                    if (!(mouseY >= (double)startY) || !(mouseY <= (double)(startY + stackDimensions))) continue;
                    return recipes.getFirstVisibleRecipeId() + column * this.recipesPerColumn + row;
                }
            }
        }
        return -1;
    }

    private void renderStoredRecipeStack(class_332 drawContext, class_1799 stack, int recipeId, int row, int column, class_465<?> gui, boolean selected) {
        class_327 font = this.mc.field_1772;
        String indexStr = String.valueOf(recipeId + 1);
        int x = column * this.columnWidth + this.gapColumn + this.numberTextWidth;
        int y = row * this.entryHeight;
        this.renderStackAt(drawContext, stack, x, y, selected);
        float scale = 0.75f;
        x = x - (int)((float)font.method_1727(indexStr) * scale) - 2;
        int n = row * this.entryHeight + this.entryHeight / 2;
        Objects.requireNonNull(font);
        y = n - 9 / 2;
        drawContext.method_51448().pushMatrix();
        drawContext.method_51448().translate((float)x, (float)y);
        drawContext.method_51448().scale(scale, scale);
        drawContext.method_51433(font, indexStr, 0, 0, -4144960, false);
        drawContext.method_51448().popMatrix();
    }

    private void renderRecipeItems(class_332 drawContext, RecipePattern recipe, int recipeCountPerPage, class_465<?> gui) {
        class_1799[] items = recipe.getRecipeItems();
        int recipeDimensions = (int)Math.ceil(Math.sqrt(Math.min(recipe.getRecipeLength(), 9)));
        int x = -49;
        int y = 3 * this.entryHeight;
        int i = 0;
        for (int row = 0; row < recipeDimensions; ++row) {
            int col = 0;
            while (col < recipeDimensions) {
                int xOff = col > 0 ? col * 17 : 0;
                int yOff = row > 0 ? row * 17 : 0;
                this.renderStackAt(drawContext, items[i], x + xOff, y + yOff, false);
                ++col;
                ++i;
            }
        }
    }

    private class_1799 getHoveredRecipeIngredient(double mouseX, double mouseY, RecipePattern recipe, int recipeCountPerPage, class_465<?> gui) {
        int recipeDimensions = (int)Math.ceil(Math.sqrt(Math.min(recipe.getRecipeLength(), 9)));
        int scaledStackDimensions = (int)(16.0 * this.scale);
        int scaledGridEntry = (int)(17.0 * this.scale);
        int x = this.recipeListX - (int)(49.0 * this.scale);
        int y = this.recipeListY + (int)((double)(3 * this.entryHeight) * this.scale);
        if (mouseX >= (double)x && mouseX <= (double)(x + recipeDimensions * scaledGridEntry) && mouseY >= (double)y && mouseY <= (double)(y + recipeDimensions * scaledGridEntry)) {
            int i = 0;
            for (int row = 0; row < recipeDimensions; ++row) {
                int col = 0;
                while (col < recipeDimensions) {
                    int xOff = col * scaledGridEntry;
                    int yOff = row * scaledGridEntry;
                    int xStart = x + xOff;
                    int yStart = y + yOff;
                    if (mouseX >= (double)xStart && mouseX < (double)(xStart + scaledStackDimensions) && mouseY >= (double)yStart && mouseY < (double)(yStart + scaledStackDimensions)) {
                        return recipe.getRecipeItems()[i];
                    }
                    ++col;
                    ++i;
                }
            }
        }
        return class_1799.field_8037;
    }

    private void renderStackAt(class_332 drawContext, class_1799 stack, int x, int y, boolean border) {
        int w = 16;
        if (border) {
            RenderUtils.drawOutline((class_332)drawContext, (int)(x - 1), (int)(y - 1), (int)18, (int)18, (int)-1);
        }
        RenderUtils.drawRect((class_332)drawContext, (int)x, (int)y, (int)16, (int)16, (int)0x20FFFFFF);
        if (!InventoryUtils.isStackEmpty(stack)) {
            stack = stack.method_7972();
            InventoryUtils.setStackSize(stack, 1);
            drawContext.method_51448().pushMatrix();
            drawContext.method_51448().translate(0.0f, 0.0f);
            drawContext.method_51427(stack, x, y);
            drawContext.method_51448().popMatrix();
        }
    }
}

