/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.itemscroller.villager;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.class_2487;
import net.minecraft.class_2497;
import net.minecraft.class_2499;
import net.minecraft.class_2520;

public class VillagerData {
    private final UUID uuid;
    private final IntArrayList favorites = new IntArrayList();
    private int tradeListPosition;

    VillagerData(UUID uuid) {
        this.uuid = uuid;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public int getTradeListPosition() {
        return this.tradeListPosition;
    }

    void setTradeListPosition(int position) {
        this.tradeListPosition = position;
    }

    void toggleFavorite(int tradeIndex) {
        if (this.favorites.contains(tradeIndex)) {
            this.favorites.rem(tradeIndex);
        } else {
            this.favorites.add(tradeIndex);
        }
    }

    IntArrayList getFavorites() {
        return this.favorites;
    }

    public class_2487 toNBT() {
        class_2487 tag = new class_2487();
        tag.method_10544("UUIDM", this.uuid.getMostSignificantBits());
        tag.method_10544("UUIDL", this.uuid.getLeastSignificantBits());
        tag.method_10569("ListPosition", this.tradeListPosition);
        class_2499 tagList = new class_2499();
        for (Integer val : this.favorites) {
            tagList.add((Object)class_2497.method_23247((int)val));
        }
        tag.method_10566("Favorites", (class_2520)tagList);
        return tag;
    }

    @Nullable
    public static VillagerData fromNBT(class_2487 tag) {
        if (tag.method_10545("UUIDM") && tag.method_10545("UUIDL")) {
            VillagerData data = new VillagerData(new UUID(tag.method_68080("UUIDM", 0L), tag.method_68080("UUIDL", 0L)));
            class_2499 tagList = tag.method_68569("Favorites");
            int count = tagList.size();
            data.favorites.clear();
            data.tradeListPosition = tag.method_68083("ListPosition", -1);
            for (int i = 0; i < count; ++i) {
                data.favorites.add(tagList.method_68576(i, -1));
            }
            return data;
        }
        return null;
    }
}

